// /////////////////////////////////////////////////////////////////////////////
// DR DOBB'S CHALLENGES
//
// Filename       : mainOptions.cpp
// Date           : February 2008
//
// Description    : This file defines the Options class responsible for
//                  handling the Main Options GUI.  Once instantiated, Update()
//                  must be called within the main game loop while the Options
//                  is active.  Start() is used to determine if a level
//                  has been selected for play.  Quit() is used to determine
//                  if the QUIT button or ESC key has been pressed to exit
//                  the application.
//
//                  GetLevel() and GetPlayer() are used to pass the selected
//                  level and player to CGame when a level is selected for
//                  play.
//
//                  Hide() and Unhide() are used to hide/unhide the main
//                  Options between level play, rather than deleting the
//                  Options each time.
//
// ///////////////////////////////////////////////////////////////////////////
#pragma once



#include "global.h"
#include "text.h"
#include "sound.h"
#include "GameState.h"



class Options : public GameState 
{

  protected:

    float                 m_CurBarPos;
    float                 m_BarTargetTime;

    int                   m_BarPos;
    int                   m_BarStartPos;

    int                   m_BarXPos[3];
    unsigned int          m_BarColor[3];



  public:

    Options();
    ~Options();


    void                  Render();
    virtual void          UpdateTimed( const float ElapsedTime );
    void                  Update();

    virtual void          Init();
    virtual void          Exit();


    virtual void          OnMouseWheel( int Dir );

};

